package gov.va.med.mhv.health.model;

import java.io.Serializable;
import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

@Entity
@Table(name="ALLERGIES")
public class Allergy implements Serializable {
	
	private static final long serialVersionUID = 2902263012762076786L;
	
    @Id
	@Column(name="ALLERGIES_ID_SEQ")
	@GeneratedValue(strategy=GenerationType.AUTO) 
	private Long id;
    
	@Column(name="OPLOCK")
	private Integer oplock;
	
	@Column(name="COMMENTS")
	private String comments;
	
	@Column(name="ALLERGY")
	private String allergy;
	
	@Column(name="EVENT_DATE")
	@Temporal(TemporalType.DATE)
	private Date eventDate;
	
	@Column(name="REACTION")
	private String reaction;
	
	@Column(name="DIAGNOSED")
	private String diagnosed;
	
	@Column(name="SEVERITY")
	private String severity;
	
	@Column(name="USER_PROFILE_USER_PROFILE_ID")
	private Long userprofileId;

	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public Integer getOplock() {
		return oplock;
	}

	public void setOplock(Integer oplock) {
		this.oplock = oplock;
	}

	public String getComments() {
		return comments;
	}

	public void setComments(String comments) {
		this.comments = comments;
	}

	public String getAllergy() {
		return allergy;
	}

	public void setAllergy(String allergy) {
		this.allergy = allergy;
	}

	public Date getEventDate() {
		return eventDate;
	}

	public void setEventDate(Date eventDate) {
		this.eventDate = eventDate;
	}

	public String getReaction() {
		return reaction;
	}

	public void setReaction(String reaction) {
		this.reaction = reaction;
	}

	public String getDiagnosed() {
		return diagnosed;
	}

	public void setDiagnosed(String diagnosed) {
		this.diagnosed = diagnosed;
	}

	public String getSeverity() {
		return severity;
	}

	public void setSeverity(String severity) {
		this.severity = severity;
	}

	public Long getUserprofileId() {
		return userprofileId;
	}

	public void setUserprofileId(Long userprofileId) {
		this.userprofileId = userprofileId;
	}
	
}
